
---
## **1. Configure Global AAA Settings**

Start by defining global AAA settings, including RADIUS server configuration, RADIUS server groups, and AAA method lists.

### **Steps to Configure RADIUS Servers:**

1. Navigate to **Configuration > Security > AAA > Servers / Groups > RADIUS > Servers**.
2. Click **Add+** and specify:
    - Server name and IP address.
    - Pre-shared key (PSK) (must match the ISE server’s PSK).
    - Optional: Configure timeout and retry count.
    - Enable **Change of Authorization (CoA)** and configure the CoA server key.
3. Click **Save & Apply to Device**.
4. Repeat the steps for multiple servers if needed.

### **Steps to Create a RADIUS Server Group:**

1. Navigate to **Configuration > Security > AAA > Servers / Groups > RADIUS > Server Groups**.
2. Click **Add+**.
3. Move servers from the **Available Servers** list to the **Assigned Servers** list.
4. Click **Save & Apply to Device**.

### **Steps to Configure AAA Authentication Method List:**

1. Navigate to **Configuration > Security > AAA > AAA Method List**.
2. Select the **Authentication** option and click **Add+**.
3. Provide a method list name and select:
    - **dot1x** as the type for 802.1X-enabled WLANs.
    - A previously configured server group from the **Available Server Groups** list.
4. Click **Save & Apply to Device**.

### **Steps to Configure AAA Accounting Method List:**

1. Navigate to **Configuration > Security > AAA > AAA Method List**.
2. Select the **Accounting** option and click **Add+**.
3. Provide a method list name and select:
    - **Identity** as the type for 802.1X-enabled WLANs.
    - A previously configured server group from the **Available Server Groups** list.
4. Click **Save & Apply to Device**.

---

## **2. Enable 802.1X Per WLAN**

Enable 802.1X authentication on individual WLANs by configuring WLAN-specific and policy profile settings.

### **Steps to Configure WLAN Settings:**

1. Navigate to **Configuration > Tags & Profile > WLANs** and select the WLAN to edit.
2. Under the **Layer 2** security settings:
    - Select a security mode (e.g., **WPA2 + WPA3**).
    - Set **Auth Key Mgmt** to **802.1X**.
    - Choose the previously configured AAA authentication method list.
3. Click **Save & Apply to Device**.

---

## **3. Configure Advanced Parameters in Policy Profiles**

Advanced settings, such as AAA override and accounting, are configured in the policy profile tied to the WLAN.

### **Steps to Configure Policy Profile:**

1. Navigate to **Configuration > Tags & Profile > Policy** and select the policy profile to edit.
2. Under the **Advanced** tab:
    - Enable **Allow AAA Override** to support dynamic VLANs, QoS, and ACLs based on RADIUS attributes.
    - Optionally, select the AAA accounting method list for accounting purposes.
3. Click **Save & Apply to Device**.

---

## **Key Notes**

- **AAA Override**: Allows settings like dynamic VLAN assignments or ACLs to be pushed from the AAA server (e.g., Cisco ISE).
- **CoA (Change of Authorization)**: Required for features like dynamic policy updates from the Cisco ISE server.
- **Policy Tags**: Ensure the policy profile is correctly tied to the WLAN for proper functionality.